<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class XL_Tab_Is_Free_Active {

  function __construct() {

    add_action( 'admin_init', array( $this, 'xl_tab_free_check' ));
  }

  function xl_tab_free_check(){

    if ( is_admin() && current_user_can( 'activate_plugins' ) && !is_plugin_active( 'xl-tab/index.php' ) ) {
        add_action( 'admin_notices', array( $this, 'free_notice' ), 10);

        deactivate_plugins( 'xltab-pro/index.php' );

        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }
    }

  }

  public function free_notice(){

    $class = 'notice notice-error';
    $plugin = 'xl-tab/index.php';
    $message = sprintf( __( 'The %1$sXl Tab Pro%2$s plugin requires %1$sXl Tab%2$s plugin installed & activated.', 'xltab' ), '<strong>', '</strong>' );

    if ( file_exists( WP_PLUGIN_DIR . '/xl-tab/index.php' ) ) {

        $action_url   = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin );
        $button_label = __( 'Activate Xl Tab', 'xltab' );

    } else {

        $action_url   = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=xl-tab' ), 'install-plugin_xl-tab' );
        $button_label = __( 'Install Xl Tab', 'xltab' );
    }

    $button = '<p><a href="' . esc_url( $action_url ) . '" class="button-primary">' . esc_html( $button_label ) . '</a></p><p></p>';

    printf( '<div class="%1$s"><p>%2$s</p>%3$s</div>', esc_attr( $class ), wp_kses_post( $message ), wp_kses_post( $button ) );

    }

}

new XL_Tab_Is_Free_Active();





