<?php

class News_Element_Pro_Style_Generation {

	function __construct() {

		add_action( 'elementor/core/files/clear_cache', array( __CLASS__, 'generate_css' ), 10, 2 );
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_css' ) );
	}

	public static function compress_css( $css ) {

		$out = str_replace( '; ', ';', str_replace( ' }', '}', str_replace( '{ ', '{', str_replace( array(
			"\r\n",
			"\r",
			"\n",
			"\t", 
			'  ',
			'    ',
			'    '
		), "", preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css ) ) ) ) );

		return $out;
	}

	public static function grab_files ($path){

		return glob( realpath($path) . '/**/*.css' );

	}

	public static function generate_css() {

		global $wp_filesystem;
		require_once( ABSPATH . 'wp-admin/includes/file.php' );
		$slider = self:: grab_files (NEWS_ELEMENT_PRO_DIR . '/widgets/slider/');
		$theme = self:: grab_files (NEWS_ELEMENT_PRO_DIR . '/widgets/theme-builder/');
		$hero = self:: grab_files (NEWS_ELEMENT_PRO_DIR . '/widgets/hero/');
		$magazine = self:: grab_files (NEWS_ELEMENT_PRO_DIR . '/widgets/magazine/');

		$all_files       = array_merge($slider,$theme,$hero,$magazine);
		$csscont         = '';
		foreach ( $all_files as $filename ) {
			$csscont .= file_get_contents( $filename );
		}

		$upload_dir = wp_upload_dir();
		$dir        = trailingslashit( $upload_dir['basedir'] );
		WP_Filesystem();
		$wp_filesystem->put_contents( $dir . 'news-element-pro.css', self::compress_css( $csscont ), 0644 );
	}

	public static function enqueue_css() {
		$uploads = wp_upload_dir();
		wp_enqueue_style( 'news-element-pro', trailingslashit( $uploads['baseurl'] ) . 'news-element-pro.css', array() );
	}

}

new News_Element_Pro_Style_Generation();

