<?php
/**
 * Plugin Name: News Element Pro
 * Plugin URI: https://codecanyon.net/user/xldevelopment/portfolio
 * Description: Awesome tab accordion for Elementor Page Builder
 * Author: Ashraf
 * Author URI: https://codecanyon.net/user/xldevelopment/portfolio
 * Version: 1.2
 */
if (!defined('ABSPATH'))
    exit;
 
if (!class_exists('News_Element_Pro')) :

    final class News_Element_Pro {
 
        private static $instance;

        public static function instance() {

            if (!isset(self::$instance) && !(self::$instance instanceof News_Element_Pro)) {

                self::$instance = new News_Element_Pro;
                self::$instance->xltab_constant();
                self::$instance->xltab_hooks();
                self::$instance->include_files();

            }
            return self::$instance;
        }

        public function __clone() {
            _doing_it_wrong(__FUNCTION__, __('Cheatin&#8217; huh?', 'iconelement'), '1.6');
        }

        public function __wakeup() {
            _doing_it_wrong(__FUNCTION__, __('Cheatin&#8217; huh?', 'iconelement'), '1.6');
        }

        private function xltab_constant() {

            // Plugin Folder Path
            if (!defined('NEWS_ELEMENT_PRO_DIR')) {
                define('NEWS_ELEMENT_PRO_DIR', plugin_dir_path(__FILE__));
            }
            // Plugin Folder URL
            if (!defined('NEWS_ELEMENT_PRO_URL')) {
                define('NEWS_ELEMENT_PRO_URL', plugin_dir_url(__FILE__));
            }
        }

        public function include_files(){

			include_once NEWS_ELEMENT_PRO_DIR . 'inc/dynamic-styles.php';
		}

        private function xltab_hooks() {

           add_action( 'elementor/widgets/register', array( $this, 'include_widgets' ) );

        }

        public function glob_widget($path,$widgets_manager){

            $files = new DirectoryIterator( $path );
            $widgets = [];
			foreach ( $files as $file ) {
                if ($file->isDot()) { continue; }
                $widgets[] = $file->getFilename();
			}
			//$active_widgets = $this->thepack_active_element( $widgets );
            $active_widgets = $widgets;
			if ( is_array( $active_widgets ) ) {
				foreach ( $active_widgets as $key => $value ) {
					if ( ! empty( $value ) ) {
						require_once $path . $value . '/index.php';
					}
				}
			}

        }

        public function include_widgets( $widgets_manager ) {
            
            $this->glob_widget( NEWS_ELEMENT_PRO_DIR . 'widgets/slider/',$widgets_manager );
            $this->glob_widget( NEWS_ELEMENT_PRO_DIR . 'widgets/hero/',$widgets_manager );
            $this->glob_widget( NEWS_ELEMENT_PRO_DIR . 'widgets/magazine/',$widgets_manager );
		}

        public function xltab_frontend_scripts() {

            //wp_enqueue_script('xltab-pro', XLTAB_PRO_URL . 'assets/js/xltab.js', array('jquery'), '', true);

        }

        public function xltab_include_widgets($widgets_manager) {


        }

    }

endif;

function xltab_pro_run() {
    return News_Element_Pro::instance();
}

xltab_pro_run();

