<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow; 
use News_Element\Khobish_Helper;
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class ne_latest_terms extends Widget_Base
{
    public function get_name()
    {
        return 'ne_latest_terms';
    } 
  
    public function get_title()
    {
        return esc_html__('Latest terms', 'educat');
    }

    public function get_icon()
    {
        return 'dashicons dashicons-image-filter';
    }

    public function get_categories()
    {
        return ['eduquest-addons'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Content', 'educat'),
            ]
        );

        $this->add_control(
            'tax',
            [
                'type' => Controls_Manager::SELECT2,
                'options' =>  Khobish_Helper::khobish_tax_drop(),
                'multiple' => false,
                'label' => esc_html__('Taxonomy', 'educat'),
                'label_block' => true,               
            ]
        );  
 
        $this->end_controls_section();

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'educat'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings();
        include dirname(__FILE__) . '/view.php';
    }

}

\Elementor\Plugin::instance()->widgets_manager->register(new ne_latest_terms());
