<?php
global $wpdb;
$query = "SELECT $wpdb->terms.term_id, $wpdb->terms.name, $wpdb->terms.slug
FROM $wpdb->terms
    INNER JOIN $wpdb->term_taxonomy ON ($wpdb->terms.term_id = $wpdb->term_taxonomy.term_id)
    INNER JOIN $wpdb->term_relationships ON ($wpdb->terms.term_id = $wpdb->term_relationships.term_taxonomy_id)
    INNER JOIN $wpdb->posts ON ($wpdb->term_relationships.object_id = $wpdb->posts.ID)
WHERE $wpdb->term_taxonomy.taxonomy = 'category'
ORDER BY $wpdb->posts.post_date DESC";
$tags= $wpdb->get_results($query); // $query being the above SQL
$stack = [];
foreach ($tags as $tag) {
    if (!isset($stack[$tag->term_id]))
        $stack[$tag->term_id] = $tag;
}

echo '<pre>' . var_export($stack, true) . '</pre>';
?>
