<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow; 
use News_Element\Khobish_Helper;
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class eq_tab extends Widget_Base
{
    public function get_name()
    {
        return 'ne_search_ajax';
    } 
  
    public function get_title()
    {
        return esc_html__('Live Search', 'educat');
    }

    public function get_icon()
    {
        return 'dashicons dashicons-image-filter';
    }

    public function get_categories()
    {
        return ['eduquest-addons'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Content', 'educat'),
            ]
        );

        $this->add_control(
            'show_tax',
            [
                'label' => esc_html__('Show category select', 'educat'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'nols',
            [
                'label' => esc_html__('Disable live search', 'educat'),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'nolive',
            ]
        );
 
        $this->add_control( 
            'show_search',
            [
                'label' => esc_html__('Show as search icon', 'educat'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'tax',
            [
                'type' => Controls_Manager::SELECT2,
                'options' =>  Khobish_Helper::khobish_tax_drop(),
                'multiple' => false,
                'label' => esc_html__('Taxonomy', 'educat'),
                'label_block' => true,
                'condition' => [
                    'show_tax' => 'yes',
                ],                
            ]
        );  
 
        $this->add_control(
            'post',
            [
                'type' => Controls_Manager::SELECT2,
                'options' =>  Khobish_Helper::post_type(),
                'multiple' => false,
                'label' => esc_html__('Post type', 'educat'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'posts',
            [
                'label' => esc_html__('Posts to show', 'educat'),
                'type' => Controls_Manager::SLIDER,
            ]
        );

        $this->add_control(
            'icon',
            [
                'type' => Controls_Manager::ICONS,
                'label' => esc_html__('Search icon', 'educat'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'place',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Input placeholder', 'educat'),
                'label_block' => true,
                'default' => 'Find Your Courses..',
            ]
        );

        $r = new \Elementor\Repeater();
        $r->add_control(
            'meta', [
                'label' =>   esc_html__( 'Post meta', 'educat' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => false,
                'options' =>  Khobish_Helper::magnews_meta_fields(),
            ]
        );
 
        $this->add_control( 
            'metaf',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $r->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ meta }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'educat'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tctb');

        $this->start_controls_tab(
            'e1',
            [
                'label' => esc_html__('Input', 'educat'),
            ]
        );

        $this->add_responsive_control(
            'inpad',
            [
                'label' => esc_html__('Padding', 'educat'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['em', 'px'],
                'selectors' => [
                    '{{WRAPPER}} .form-control' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'inbg',
            [
                'label' => esc_html__('Background', 'educat'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .form-control' => 'background:{{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'inclr',
            [
                'label' => esc_html__('Text color', 'educat'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .form-control' => 'color:{{VALUE}};',
                    '{{WRAPPER}} .form-control::placeholder' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'in0clr',
            [
                'label' => esc_html__('Border Color', 'educat'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .form-control' => 'border:1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'in_ty',
                'label' => esc_html__('Typography', 'educat'),
                'selector' => '{{WRAPPER}} .form-control',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'e2',
            [
                'label' => esc_html__('Select', 'educat'),
                'condition' => [
                    'show_tax' => 'yes',
                ],                 
            ]
        );

        $this->add_responsive_control(
            'selwid',
            [
                'label' => __('Width', 'educat'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} select' => 'flex:0 0 {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'selpad',
            [
                'label' => esc_html__('Padding', 'educat'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['em', 'px'],
                'selectors' => [
                    '{{WRAPPER}} select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'sebg',
            [
                'label' => esc_html__('Background', 'educat'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} select' => 'background:{{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'seclr',
            [
                'label' => esc_html__('Text color', 'educat'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} select' => 'color:{{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sel_ty',
                'label' => esc_html__('Typography', 'educat'),
                'selector' => '{{WRAPPER}} select',
            ]
        );


        $this->end_controls_tab();

        $this->start_controls_tab(
            'e3',
            [
                'label' => esc_html__('Button', 'educat'),
            ]
        );

        $this->add_control(
            'pi_clr',
            [
                'label' => esc_html__('Color', 'educat'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pi_bclr',
            [
                'label' => esc_html__('Border Color', 'educat'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-btn' => 'border:1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pi_bg',
            [
                'label' => esc_html__('Background', 'educat'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-btn' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'pitrd',
            [
                'label' => esc_html__('Border radius', 'educat'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .search-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'piwh',
            [
                'label' => esc_html__('Width height', 'educat'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .search-btn' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
  
            ]
        ); 

        $this->end_controls_tab();

        $this->start_controls_tab(
            'e4',
            [
                'label' => esc_html__('Preloader', 'educat'),
            ]
        );

        $this->add_responsive_control(
            'priwh',
            [
                'label' => esc_html__('Width height', 'educat'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .ne-loader' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};margin-top:calc(-{{SIZE}}{{UNIT}}/2);margin-left:calc(-{{SIZE}}{{UNIT}}/2);',
                ],

            ]
        );

        $this->add_responsive_control(
            'prrs',
            [
                'label' => esc_html__('Right spacing', 'educat'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .ne-loader' => 'right: {{SIZE}}{{UNIT}};',
                ],

            ]
        );


        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'section_result',
            [
                'label' => esc_html__('Result wrapper', 'educat'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'gitsp',
            [
                'label' => __( 'Gap', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .khobish-ajax-wrap' => 'gap:{{SIZE}}{{UNIT}};',                    
                ],
            ]
        );


        do_action('newsmag_block_style', $this,'fwrb_','.khobish-ajax-wrap','Wrapper');

        do_action('newsmag_flex_list', $this,'r_','.post-item');

        $this->end_controls_section();

        $this->start_controls_section(
            'section_fblock',
            [
                'label' => __('Post title', 'news-element'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        do_action('newsmag_post_title_style', $this,'md_','.entry_title');

        $this->end_controls_section();

        $this->start_controls_section(
            'section_bmeta',
            [
                'label' => __('Post Meta', 'news-element'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        do_action('newsmag_post_meta_style', $this,'');

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings();
        include dirname(__FILE__) . '/view.php';
    }

}

\Elementor\Plugin::instance()->widgets_manager->register(new eq_tab());
