<?php
namespace News_Element\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Utils;
use News_Element\Khobish_Helper;
use News_Element\Widgets\Group_Query;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class ae_slider_1 extends Widget_Base {

    public function get_name() {
        return 'ae_carousel';
    }
 
    public function get_title() {
        return __('Slider 1', 'news-element');
    }

    public function get_icon() {
        return 'eicon-posts-group';
    }

    public function get_categories() {
        return array('khobish-element');
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_posts_carousel',
            [
                'label' => __('Query', 'news-element'),
            ]
        );

        $this->add_control(

            'style', [
                'type' => Controls_Manager::SELECT,
                'label' => __('Style', 'news-element'),
                'default' => 'style_one',
                'options' => [
                    'style_one' => __('Style 1', 'news-element'),
                    'style_two' => __('Style 2', 'news-element'),
                    'style_three' => __('Style 3', 'news-element'),
                    'style_four' => __('Style 4', 'news-element'),
                    'style_five' => __('Style 5', 'news-element'),
                    'style_six' => __('Style 6', 'news-element'),
                ],
            ]
        );
 
        $this->add_group_control(
            Group_Query::get_type(),
            [
                'name' => 'query',
            ]
        );

        $this->add_control(
            'post_perpage',
            [
                'label' => __('Post per page', 'news-element'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => 'px',
                    'size' => 5,
                ],                
            ]
        );

        $this->add_control(
            'offset',
            [
                'label' => __('Offset', 'news-element'),
                'type' => Controls_Manager::SLIDER,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Order', 'news-element' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC' => 'ASC',
                    'DESC' => 'DESC',
                ],
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('Order by', 'news-element'),
                'type' => Controls_Manager::SELECT2,
                'options' => Khobish_Helper::khobish_order_by(),
                'default' => 'ID',
                'multiple' => false,
                'label_block' => true,
            ]
        );
        $this->start_controls_tabs('pmrts');

        $this->start_controls_tab(
            'e1',
            [
                'label' => esc_html__( 'Big', 'news-element' ),
            ]
        );

        $r1 = new \Elementor\Repeater();
        $r1->add_control(
            'meta', [
                'label' =>   esc_html__( 'Post meta', 'news-element' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => false,
                'options' =>  Khobish_Helper::magnews_meta_fields(),
            ]
        );

        $this->add_control(
            'metaf',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $r1->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ meta }}}',
            ]
        );

        $this->add_control(
            'excerpt',
            [
                'label' => __( 'Excerpt length', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],

            ]
        );

        $this->add_control(
            'img_size',
            [
                'label' => __('Image size', 'news-element'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' =>  Khobish_Helper::ae_image_size_choose(),
                'multiple' => false,
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'e2',
            [
                'label' => esc_html__( 'Small', 'news-element' ),
            ]
        );

        $r1r = new \Elementor\Repeater();
        $r1r->add_control(
            'meta', [
                'label' =>   esc_html__( 'Post meta', 'news-element' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => false,
                'options' =>  Khobish_Helper::magnews_meta_fields(),
            ]
        );

        $this->add_control(
            'metar',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $r1r->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ meta }}}',
            ]
        );

        $this->add_control(
            'img_sizer',
            [
                'label' => __('Image size', 'news-element'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' =>  Khobish_Helper::ae_image_size_choose(),
                'multiple' => false,
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => __('General', 'news-element'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this->add_control(
            'filtr',
            [
                'label' =>   esc_html__('Hide overlay category', 'news-element'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' =>   esc_html__('Yes', 'news-element'),
                'label_off' =>   esc_html__('No', 'news-element'),
                'selectors' => [
                    '{{WRAPPER}} .overlaycat' => 'display: none;',
                ],
            ]
        );

        $this->add_control(
            'txt_align',
            [
                'label' => __('Alignment', 'news-element'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'news-element'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'news-element'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'news-element'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .thumb-content' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'ovht',
            [
                'label' => __( 'Overlay height', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .slide-bg:after' => 'height: {{SIZE}}%;',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'ovbg',
                'label' =>   esc_html__( 'Color', 'news-element' ),
                'types' => [ 'none', 'classic','gradient' ],
                'selector' => '{{WRAPPER}} .slide-bg:after',
            ]
        );

        $this->start_controls_tabs('gtabs');

        $this->start_controls_tab(
            'a1',
            [
                'label' => esc_html__( 'Small', 'news-element' ),
            ]
        );

        $this->add_responsive_control(
            'sheight',
            [
                'label' => __('Height', 'news-element'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'max' => 1200,
                        'min' => 1,
                        'step' => 1,
                    ],
                ],

                'selectors' => [
                    '{{WRAPPER}} .fourth-slider-1' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-2' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-3' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .sixth-slider-1 >*' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .sixth-slider-3 >*' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-3' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-4' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-0' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-3' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-4' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-5' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-0' => 'height: {{SIZE}}{{UNIT}};',

                    '{{WRAPPER}} .second-slider-2' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-3' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-0' => 'height: {{SIZE}}{{UNIT}};',

                ]
            ]
        );


        $this->add_control(
            'sovpd',
            [
                'label' => __('Padding', 'elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .rest' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'a2',
            [
                'label' => esc_html__( 'Big', 'news-element' ),
            ]
        );

        $this->add_responsive_control(
            'mheight',
            [
                'label' => __('Height', 'news-element'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'max' => 1200,
                        'min' => 1,
                        'step' => 1,
                    ],
                ],

                'selectors' => [
                    '{{WRAPPER}} .slider-a-wrap.main' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-4' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-0' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .sixth-slider-2 >*' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-1' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-2' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-1' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-2' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-1' => 'height: {{SIZE}}{{UNIT}};',

                ]
            ]
        );

        $this->add_control(
            'bovpd',
            [
                'label' => __('Padding', 'elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .first' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

         $this->start_controls_section(
            'section_style3',
            [
                'label' => __('Background Category', 'news-element'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'm_typography',
                'selector' => '{{WRAPPER}} .thumb-overlay .cat-bg',
                'label' => __( 'Typography', 'news-element' ),
            ]
        );

        $this->add_control(
            'meta_margins',
            [
                'label' => __('Padding', 'elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .thumb-overlay .cat-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'm_color',
            [
                'label' => __( 'Color', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thumb-overlay .cat-bg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'm_colorbg',
            [
                'label' => __( 'Background', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thumb-overlay .cat-bg' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_taxo',
            [
                'label' => __('Thumb overlay category', 'news-element'),
                'tab' => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'filtr!' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tax_typography',
                'selector' => '{{WRAPPER}} .overlaycat .cat-bg',
            ]
        );

        $this->add_responsive_control(
            'tax_pad',
            [
                'label' => __('Padding', 'news-element'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .overlaycat .cat-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->add_control(
            'tax_color',
            [
                'label' => __( 'Color', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .overlaycat .cat-bg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tax_bgcolor',
            [
                'label' => __( 'Background', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .overlaycat .cat-bg' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->start_controls_tabs('ovcat');

        $this->start_controls_tab(
            'x1',
            [
                'label' => esc_html__( 'Small', 'news-element' ),
            ]
        );

        $this->add_responsive_control(
            'thmtsp',
            [
                'label' => __( 'Top spacing', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ]
                ],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .sixth-slider-1 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .sixth-slider-3 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-3 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-4 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-0 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-1 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-2 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-3 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-3 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-4 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-5 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-0 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-1 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-2 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-3 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-0 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',

                    '{{WRAPPER}} .mag-item-2 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            'thmlsp',
            [
                'label' => __( 'Left spacing', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ]
                ],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .sixth-slider-1 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .sixth-slider-3 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-3 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-4 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-0 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-1 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-2 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-3 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',

                    '{{WRAPPER}} .third-slider-3 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-4 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-5 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-0 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',

                    '{{WRAPPER}} .second-slider-2 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-3 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-0 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',

                    '{{WRAPPER}} .mag-item-2 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'x2',
            [
                'label' => esc_html__( 'Big', 'news-element' ),
            ]
        );

        $this->add_responsive_control(
            'bsp',
            [
                'label' => __( 'Top spacing', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ]
                ],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .sixth-slider-2 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-1 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-2 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-4 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-0 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-1 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-2 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-1 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mag-item-1 .overlaycat' => 'top: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            'gtsp',
            [
                'label' => __( 'Left spacing', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ]
                ],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .sixth-slider-2 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-1 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .five-slider-2 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-4 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fourth-slider-0 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-1 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .third-slider-2 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .second-slider-1 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mag-item-1 .overlaycat' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'section_title',
            [
                'label' => __('Title', 'news-element'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this->start_controls_tabs('ttl');

        $this->start_controls_tab(
            'x3',
            [
                'label' => esc_html__( 'Big', 'news-element' ),
            ]
        );

        $this->add_control(
            'sh_clr',
            [
                'label' => __( 'Color', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .first .entry_title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'stclr',
            [
                'label' => __( 'Color hover', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .first .entry_title:hover a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'stmr',
            [
                'label' => __('Margin', 'news-element'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .first .entry_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sttl',
                'label' => __('Typography', 'news-element'),
                'selector' => '{{WRAPPER}} .first .entry_title',
            ]
        );


        $this->end_controls_tab();

        $this->start_controls_tab(
            'x4',
            [
                'label' => esc_html__( 'Small', 'news-element' ),
            ]
        );

        $this->add_control(
            'th_clr',
            [
                'label' => __( 'Color', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rest .entry_title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'ftclr',
            [
                'label' => __( 'Color hover', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rest .entry_title:hover a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'ftmr',
            [
                'label' => __('Margin', 'news-element'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .rest .entry_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ftttl',
                'label' => __('Typography', 'news-element'),
                'selector' => '{{WRAPPER}} .rest .entry_title',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'section_bmeta',
            [
                'label' => __('Meta', 'news-element'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this->add_control(
            'mtm_color',
            [
                'label' => __( 'Meta color', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .leffect-1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'mtm_colora',
            [
                'label' => __( 'Meta link color', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .leffect-1 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'mtm_typo',
                'label' => __('Typography', 'news-element'),
                'selector' => '{{WRAPPER}} .leffect-1',
            ]
        );

        $this->add_responsive_control(
            'metaspcy',
            [
                'label' => __('Meta spacing', 'news-element'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .meta-space' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_fblock',
            [
                'label' => __('Excerpt', 'news-element'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'fexcert_typography',
                'label' => __('Excerpt typography', 'news-element'),
                'selector' => '{{WRAPPER}} .entry_excerpt',
            ]
        );

        $this->add_control(
            'excrtf_color',
            [
                'label' => __( 'Excerpt color', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .entry_excerpt' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'fexcerpt_pad',
            [
                'label' => __('Excerpt padding', 'news-element'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .entry_excerpt' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_carousel',
            [
                'label' => __('Carousel', 'news-element'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this->add_control(
            'sfw',
            [
                'label' => __('Boxed layout', 'news-element'),
                'type' => Controls_Manager::SWITCHER,
                 'selectors' => [
                        '{{WRAPPER}} .swiper' => 'overflow:hidden;',
                 ],
            ]
        );

        $this->add_control(
            'arrow',
            [
                'label' => __('Arrow', 'news-element'),
                'type' => Controls_Manager::SWITCHER,
            ]
        ); 

        $this->add_control(
            'dot',
            [
                'label' => __('Dot', 'news-element'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'auto',
            [
                'label' => __('Autoplay', 'news-element'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'news-element'),
                'label_off' => __('No', 'news-element'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'transition',
            [
                'label' => __('Transition', 'news-element'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Fade', 'news-element'),
                'label_off' => __('Slide', 'news-element'),
                'return_value' => 'fade',
            ]
        );

        $this->add_control(
            'speed',
            [
                'label' => __( 'Autoplay Speed', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'default' => [
                    'size' => 3500,
                ],
                'condition' => [
                    'auto' => 'yes',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 8000,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_owl_dot',
            [
                'label' => __('Dots', 'news-element'),
                'tab' => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'dot' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'dtvp',
            [
                'label' => __( 'Vertical position', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ],

                ],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination' => 'bottom: {{SIZE}}{{UNIT}};',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'dotbg',
                'label' =>   esc_html__( 'Color', 'news-element' ),
                'types' => [ 'none', 'classic','gradient' ],
                'selector' => '{{WRAPPER}} .owl-dots span',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_owl_arw',
            [
                'label' => __('Arrow', 'news-element'),
                'tab' => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'arrow' => 'yes',
                ],
            ]
        );

        $this->add_control(
			'picon', [
				'type'        => Controls_Manager::ICONS,
				'label'       => esc_html__( 'Prev icon', 'news-element' ),
				'label_block' => true,
				'default'     => [
					'value'   => 'fas fa-chevron-left',
					'library' => 'solid',
				],
			]
		);

		$this->add_control(
			'nicon', [
				'type'        => Controls_Manager::ICONS,
				'label'       => esc_html__( 'Next icon', 'news-element' ),
				'label_block' => true,
				'default'     => [
					'value'   => 'fas fa-chevron-right',
					'library' => 'solid',
				],
			]
		);

        $this->add_responsive_control(
            'arwh',
            [
                'label' =>   esc_html__( 'Width and height', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],

                ],
                'selectors' => [
                    '{{WRAPPER}} .khbprnx' => 'width: {{SIZE}}px;height: {{SIZE}}px;',
                ],

            ]
        );

        $this->add_responsive_control(
            'arbrad',
            [
                'label' =>   esc_html__( 'Border radius', 'news-element' ),
                'type' =>  Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],

                ],
                'selectors' => [
                    '{{WRAPPER}} .khbprnx' => 'border-radius: {{SIZE}}px;',
                ],

            ]
        );

        $this->add_control(
            'arbg',
            [
                'label' =>   esc_html__( 'Background', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .khbprnx' => 'background: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'arclr',
            [
                'label' =>   esc_html__( 'Color', 'news-element' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .khbprnx' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings();
        require dirname(__FILE__) .'/view.php';

    }

    protected function content_template() {
    }

}

if ( defined( 'ELEMENTOR_VERSION' ) && version_compare( ELEMENTOR_VERSION, '3.5.0', '>=' ) ) {
    $widgets_manager->register(new \News_Element\Widgets\ae_slider_1());
} else {
    $widgets_manager->register_widget_type(new \News_Element\Widgets\ae_slider_1());
}