<?php
use News_Element\Khobish_Helper;

$excerpt = $settings['excerptf']['size'];
$posts = $settings['posts']['size'];
$imgf = $settings['imgf'];
$metaf = Khobish_Helper::king_buildermeta_to_string($settings['metas']);

$cat = $settings['cat_query'];
$id = $settings['id_query']; 

if($settings['query_type'] == 'category'){
    $query_args = array(
        'post_type' => 'post',
        'posts_per_page' => $posts,
        'tax_query' => array(
            array(
                'taxonomy' => 'category',
                'field' => 'term_id',
                'terms' => $cat,
            ) ,
        ) ,
    );
}

if($settings['query_type'] == 'individual'){
    $query_args = array(
        'post_type' => 'post',
        'posts_per_page' => $posts,
        'post__in' =>$id,
        'orderby' => 'post__in'
    );
}

$slider_options = [

    'mouse' => ('yes' === $settings['mouse']),
    'auto' => ('yes' === $settings['auto']),
    'speed' => $settings['speed']['size'],
];

$loop = new \WP_Query($query_args);

?>
<div class="khobish-slider-three-wrap khobish-four-slide">
  <?php echo '<div class="swiper-containerr khobish-slider-three" data-xld ='.wp_json_encode($slider_options).'>';?>
    <div class="owl-carousel">

      <?php if ($loop->have_posts()) : ?>
              <?php while ($loop->have_posts()) : $loop->the_post();
               ?>

                   <div class="khobish-flex-inr">                   
                    <div class="ft-thumbwrap <?php echo Khobish_Helper::xl_post_format_icon();?>">
                      <a href="<?php the_permalink();?>">
                        <span class="khbmedia icon"></span>
                        <?php the_post_thumbnail($imgf);?>
                      </a>
                    </div> 
                    <div class="excerpt-wrap">
                      <div class="inrexcerpt">
                        <?php Khobish_Helper::ae_build_postmeta($metaf,$excerpt);?>
                      </div>
                    </div>                                            
                  </div>
       
              <?php endwhile; ?>

              <?php wp_reset_postdata(); ?>
              
      <?php endif;?>

    </div>

      <div class="khbprnx khbnxt"><i class="fa fa-chevron-left"></i></div>
      <div class="khbprnx khbprev"><i class="fa fa-chevron-right"></i></div>     

  </div>
  <div class="swiper-pagination"></div>
</div>
